% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{swap_parametrization}
\alias{swap_parametrization}
\title{Swap the parametrization of object of class 'gsmar' defining a gsmar model}
\usage{
swap_parametrization(gsmar, calc_std_errors = TRUE, custom_h = NULL)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{calc_std_errors}{should approximate standard errors be calculated?}

\item{custom_h}{A numeric vector of with same length as the parameter vector of the estimated model: i:th element
of custom_h is the difference used in central difference approximation for differentials of the log-likelihood function
for the i:th parameter. If \code{NULL} (default), then the difference used for differentiating overly large degrees of
freedom parameters is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}
}
\value{
Returns an object of class \code{'gsmar'} defining the specified GMAR, StMAR or G-StMAR model. If data is supplied, the returned object
  contains (by default) empirical mixing weights, conditional means and variances and quantile residuals. Note that the first p observations are
  taken as the initial values so mixing weights, conditional moments and qresiduals start from the p+1:th observation (interpreted as t=1).
}
\description{
\code{swap_parametrization} swaps the parametrization of object of class '\code{gsmar}'
 to \code{"mean"} if the current parametrization is \code{"intercept"}, and vice versa.
}
\details{
\code{swap_parametrization} is convenient tool if you have estimated the model in
 "intercept"-parametrization, but wish to work with "mean"-parametrization in the future, or vice versa.
 In \code{gsmarkit}, for example the approximate standard errors are only available for
 parametrized parameters.
}
\examples{
# GMAR model with intercept parametrization
params12 <- c(0.18, 0.93, 0.01, 0.86, 0.68, 0.02, 0.88)
gmar12 <- GSMAR(data=logVIX, p=1, M=2, params=params12, model="GMAR")
gmar12

# Swap to mean parametrization
gmar12 <- swap_parametrization(gmar12)
gmar12
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for the G-StMAR model, but it's a straightforward generalization with
           theoretical properties similar to the GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}, \code{\link{swap_parametrization}}, \code{\link{stmar_to_gstmar}}
}
