% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastGMAR.R
\name{forecastGMAR}
\alias{forecastGMAR}
\title{Forecast GMAR pr StMAR process}
\usage{
forecastGMAR(data, p, M, params, StMAR = FALSE, restricted = FALSE,
  constraints = FALSE, R, nsteps, conflevel = c(0.95, 0.8), nsimu = 10000,
  printRes = TRUE, plotRes = TRUE, nt, useMean = FALSE)
}
\arguments{
\item{data}{a numeric vector or column matrix or an (univariate) time series object containing the data. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the order of AR coefficients.}

\item{M}{a positive integer specifying the number of mixture components or regimes.}

\item{params}{a real valued parameter vector specifying the model.
\describe{
  \item{For \strong{non-restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
        \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
      \item{With \strong{linear constraints}:}{Replace the vectors \strong{\eqn{\phi_{m}}} with vectors \strong{\eqn{\psi_{m}}} and provide a  list of constraint
        matrices \strong{R} that satisfy \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
        \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
    }
  }
  \item{For \strong{restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(3M+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1})}, where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{M})}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(4M+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M})}.}
      \item{With \strong{linear constraints}:}{Replace the vector \strong{\eqn{\phi}} with vector \strong{\eqn{\psi}} and provide a constraint matrix
        \strong{\eqn{R}} that satisfies \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}, where
        \strong{\eqn{\psi}}\eqn{=(\psi_{1},...,\psi_{q})}.}
    }
  }
}
Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight and \eqn{v} a degrees of
freedom parameter.
Note that in the case \strong{M=1} the parameter \eqn{\alpha} is dropped, and in the case of \strong{StMAR} model
the degrees of freedom parameters \eqn{\nu_{m}} have to be larger than \eqn{2}.}

\item{StMAR}{an (optional) logical argument stating whether StMAR model should be considered instead of GMAR model. Default is \code{FALSE}.}

\item{restricted}{an (optional) logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes. Default is \code{FALSE}.}

\item{constraints}{an (optional) logical argument stating whether general linear constraints should be applied to the model. Default is \code{FALSE}.}

\item{R}{Specifies the linear constraints.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{R_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{R}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
Symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the nominal order of AR coefficients is alway \code{p} for all regimes.
This argument is ignored if \code{constraints==FALSE}.}

\item{nsteps}{a positive integer specifying how many steps in the future should be forecasted.}

\item{conflevel}{an (optional) numeric vector whose elements are in the open interval \eqn{(0,1)},
specifying the confidence levels for the confidence intervals that should be calculated. Default is \code{c(0.95, 0.8)}.}

\item{nsimu}{an (optional) positive integer specifying to how many simulations the forecast should be based on. Default is 10000.}

\item{printRes}{an (optional) logical argument defining wether results should be printed or not. Default is \code{TRUE}.}

\item{plotRes}{an (optional) logical argument defining wether the forecast should be plotted or not. Default is \code{TRUE}.}

\item{nt}{an (optional) positive integer specifying the number of observations to be plotted along with the prediction. Default is \code{round(length(data)*0.2)}.}

\item{useMean}{set TRUE if the prediction should be based on sample mean instead of median. Default is FALSE.}
}
\value{
Returns a data frame containing the empirical best predicton and confidence intervals accordingly to \code{conflevel}.
}
\description{
\code{forecastGMAR} forecasts the specified GMAR or StMAR process by using the given data to simulate
 its possible future values.
}
\details{
\code{forecastGMAR} uses the last \code{p} values of the given data to simulate \code{nsimu} possible future values for each step.
  The best prediction is then obtained by calculating the sample median (or mean) of each step and the confidence intervals are obtained from the empirical fractiles.
}
\examples{
\donttest{
# GMAR model
params12 <- c(1.1, 0.9, 0.3, 4.5, 0.7, 3.2, 0.8)
pred12 <- forecastGMAR(VIX, 1, 2, params12, nsteps=10)

# Restricted GMAR model
params12r <- c(1.4, 1.8, 0.9, 0.3, 3.2, 0.8)
pred12r <- forecastGMAR(VIX, 1, 2, params12r, restricted=TRUE, nsteps=20,
                        conflevel=c(0.9, 0.8, 0.6), nt=200)

# StMAR model
params12t <- c(1.1, 0.9, 0.3, 4.5, 0.7, 3.2, 0.8, 5, 8)
pred12t <- forecastGMAR(VIX, 1, 2, params12t, StMAR=TRUE, nsteps=1)

# Non-mixture version of StMAR model with data as (fictional) time series object
params11t <- c(0.76, 0.93, 1.4, 2.4)
pred11t <- forecastGMAR(ts(VIX, start=1900, freq=12), 1, 1, params11t,
                        StMAR=TRUE, nsteps=5, useMean=TRUE)

# GMAR model as a mixture of AR(2) and AR(1) models
R <- list(diag(1, ncol=2, nrow=2), as.matrix(c(1, 0)))
params22c <- c(1.2, 0.8, 0.1, 0.3, 3.3, 0.8, 2.8, 0.8)
pred22c <- forecastGMAR(VIX, 2, 2, params22c, constraints=TRUE, R=R,
                        nsteps=15, conflevel=c(0.99, 0.9, 0.8))

# Such StMAR(3,2) that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero.
params32trc <- c(2.2, 1.8, 0.88, -0.03, 2.4, 0.27, 0.40, 3.9, 1000)
pred32trc <- forecastGMAR(VIX, 3, 2, params32trc, StMAR=TRUE, restricted=TRUE, constraints=TRUE,
                          R=matrix(c(1, 0, 0, 0, 0, 1), ncol=2), nsteps=5)
}
}
