% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_knn.R
\name{ts_knn}
\alias{ts_knn}
\title{KNN time series prediction}
\usage{
ts_knn(preprocess = NA, input_size = NA, k = NA)
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{k}{number of k neighbors}
}
\value{
returns a \code{ts_knn} object.
}
\description{
Creates a prediction object that
uses the K-Nearest Neighbors (KNN) method for time series regression
}
\examples{
library(daltoolbox)
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_knn(ts_norm_gminmax(), input_size=4, k=3)
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
