% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{split_by}
\alias{split_by}
\alias{case_na}
\alias{as.tsibble}
\alias{fill_na}
\alias{find_duplicates}
\title{Deprecated functions}
\usage{
split_by(x, ...)

case_na(formula)

as.tsibble(x, ...)

fill_na(.data, ..., .full = FALSE)

find_duplicates(data, key = id(), index, fromLast = FALSE)
}
\arguments{
\item{x}{A data frame.}

\item{...}{A list of unquoted variables, separated by commas, to split a dataset.}

\item{formula}{A two-sided formula. The LHS expects a vector containing \code{NA},
and the RHS gives the replacement value.}

\item{data}{A \code{tbl_ts} object.}

\item{key}{Structural variable(s) that define unique time indices, used with
the helper \link{id}. If a univariate time series (without an explicit key),
simply call \code{id()}.}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{fromLast}{\code{TRUE} does the duplication check from the last of identical
elements.}
}
\value{
A logical vector of the same length as the row number of \code{data}
}
\description{
A thin wrapper of \code{dplyr::case_when()} if there are \code{NA}s

Find which row has duplicated key and index elements
}
\examples{
pedestrian \%>\% 
  split_by(Sensor)
x <- rnorm(10)
x[c(3, 7)] <- NA_real_
case_na(x ~ 10)
case_na(x ~ mean(x, na.rm = TRUE))
}
\seealso{
\link[dplyr:case_when]{dplyr::case_when}
}
\keyword{internal}
