% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R
\name{select.tbl_ts}
\alias{select.tbl_ts}
\alias{rename.tbl_ts}
\alias{mutate.tbl_ts}
\alias{summarise.tbl_ts}
\alias{summarize.tbl_ts}
\title{Column-wise verbs}
\usage{
\method{select}{tbl_ts}(.data, ..., drop = FALSE)

\method{rename}{tbl_ts}(.data, ...)

\method{mutate}{tbl_ts}(.data, ..., drop = FALSE)

\method{summarise}{tbl_ts}(.data, ..., drop = FALSE)

\method{summarize}{tbl_ts}(.data, ..., drop = FALSE)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{A set of name-value pairs of expressions.}

\item{drop}{\code{FALSE} returns a tsibble object as the input. \code{TRUE} drops a
tsibble and returns a tibble.}
}
\description{
\code{select()} selects columns by variables; \code{mutate()} adds new variables;
\code{summarise()} collapses the rows by variables.
}
\details{
\itemize{
\item These column-wise verbs from dplyr have an additional argument of \code{drop = FALSE}
for tsibble. The index variable cannot be dropped for a tsibble. If any key
variable is changed, it will validate whether it's a tsibble internally.
Turning \code{drop = TRUE} converts to a tibble first and then do the operations.
\item \code{summarise()} will not collapse on the index variable.
}
}
\seealso{
\link[dplyr:select]{dplyr::select}

\link[dplyr:rename]{dplyr::rename}

\link[dplyr:mutate]{dplyr::mutate}

\link[dplyr:summarise]{dplyr::summarise}

\link[dplyr:summarize]{dplyr::summarize}
}
