% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.r
\docType{class}
\name{model_specs-class}
\alias{model_specs-class}
\title{Setup base learning models}
\description{
This class sets up the base learning models and respective
parameters setting to learn the ensemble.
}
\section{Slots}{

\describe{
\item{\code{learner}}{character vector with the base learners
to be trained. Currently available models are:
\describe{
\item{\strong{bm_gaussianprocess}}{Gaussian Process models, from the
\strong{kernlab} package. See \code{\link[kernlab]{gausspr}}
for a complete description and possible parametrization. See
\code{\link{bm_gaussianprocess}} for the function implementation.}

\item{\strong{bm_ppr}}{Projection Pursuit Regression models, from the
\strong{stats} package. See \code{\link[stats]{ppr}}
for a complete description and possible parametrization. See
\code{\link{bm_ppr}} for the function implementation.}

\item{\strong{bm_glm}}{Generalized Linear Models, from the
\strong{glmnet} package. See \code{\link[glmnet]{glmnet}}
for a complete description and possible parametrization. See
\code{\link{bm_glm}} for the function implementation.}

\item{\strong{bm_gbm}}{Generalized Boosted Regression models, from the
\strong{gbm} package. See \code{\link[gbm]{gbm}}
for a complete description and possible parametrization. See
\code{\link{bm_gbm}} for the function implementation.}

\item{\strong{bm_randomforest}}{Random Forest models, from the
\strong{ranger} package. See \code{\link[ranger]{ranger}}
for a complete description and possible parametrization. See
\code{\link{bm_randomforest}} for the function implementation.}

\item{\strong{bm_cubist}}{M5 tree models, from the
\strong{Cubist} package. See \code{\link[Cubist]{cubist}}
for a complete description and possible parametrization. See
\code{\link{bm_cubist}} for the function implementation.}

\item{\strong{bm_mars}}{Multivariate Adaptive Regression Splines models, from the
\strong{earth} package. See \code{\link[earth]{earth}}
for a complete description and possible parametrization. See
\code{\link{bm_mars}} for the function implementation.}

\item{\strong{bm_svr}}{Support Vector Regression models, from the
\strong{kernlab} package. See \code{\link[kernlab]{ksvm}}
for a complete description and possible parametrization. See
\code{\link{bm_svr}} for the function implementation.}

\item{\strong{bm_ffnn}}{Feedforward Neural Network models, from the
\strong{nnet} package. See \code{\link[nnet]{nnet}}
for a complete description and possible parametrization. See
\code{\link{bm_ffnn}} for the function implementation.}

\item{\strong{bm_pls_pcr}}{Partial Least Regression and Principal
Component Regression models, from the \strong{pls} package.
See \code{\link[pls]{mvr}} for a complete description
and possible parametrization. See \code{\link{bm_pls_pcr}}
for the function implementation.}
}}

\item{\code{learner_pars}}{a list with parameter setting for the
\strong{learner}. For each model, a inner list should be created
with the specified parameters.

Check each implementation to see the possible
variations of parameters (also examplified below).}
}}

\examples{
# A PPR model and a GLM model with default parameters
model_specs(learner = c("bm_ppr", "bm_glm"), learner_pars = NULL)


# A PPR model and a SVR model. The listed parameters are combined
# with a cartesian product.
# With these specifications an ensemble with 6 predictive base
# models will be created. Two PPR models, one with 2 nterms
# and another with 4; and 4 SVR models, combining the kernel
# and C parameters.
specs <- model_specs(
 c("bm_ppr", "bm_svr"),
 list(bm_ppr = list(nterms = c(2, 4)),
      bm_svr = list(kernel = c("vanilladot", "polydot"), C = c(1,5)))
)

# All parameters currently available (parameter values can differ)
model_specs(
 learner = c("bm_ppr", "bm_svr", "bm_randomforest",
             "bm_gaussianprocess", "bm_cubist", "bm_glm",
             "bm_gbm", "bm_pls_pcr", "bm_ffnn", "bm_mars"
         ),
 learner_pars = list(
    bm_ppr = list(
       nterms = c(2,4),
       sm.method = "supsmu"
     ),
    bm_svr = list(
       kernel = "rbfdot",
       C = c(1,5),
       epsilon = .01
     ),
    bm_glm = list(
       alpha = c(1, 0)
     ),
    bm_randomforest = list(
       num.trees = 500
     ),
    bm_gbm = list(
       interaction.depth = 1,
       shrinkage = c(.01, .005),
       n.trees = c(100)
     ),
    bm_mars = list(
       nk = 15,
       degree = 3,
       thresh = .001
     ),
    bm_ffnn = list(
       size = 30,
       decay = .01
     ),
    bm_pls_pcr = list(
       method = c("kernelpls", "simpls", "cppls")
     ),
    bm_gaussianprocess = list(
       kernel = "vanilladot",
       tol = .01
     ),
    bm_cubist = list(
       committees = 50,
       neighbors = 0
     )
  )
)

}
\keyword{internal}
