% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dec.table.R
\name{dec.table}
\alias{dec.table}
\title{generate three-stage dose-finding decision table}
\usage{
dec.table(alpha.l, alpha.r, alpha.u, pc, pc.u, n, sf = "Pocock")
}
\arguments{
\item{alpha.l}{left-side overall type 1 error. Control the upper bound of dose escalation.}

\item{alpha.r}{right-side overall type 1 error. Control the lower bound of dose de-escalatition.}

\item{alpha.u}{right-side overall type 1 error. This also controls the lower bound of dose de-escalatition, but it is used to find lower bound for "DU".}

\item{pc}{a numeric vector of target toxicity. Should be a vector with 1 or 2(when the target is an interval).}

\item{pc.u}{a numeric vector of target toxicity which is used to obtain "DU" in the decision table.}

\item{n}{a vector of sample size at each stage. \code{sum(n)} is the total sample size. For A+B designs, \code{n} is a vector with length 2; for A+B+C designs, \code{n} has length 3.}

\item{sf}{the alpha-spending function to be used. \code{sf="OF"} or "\code{sf="Pocock"} uses spending function in R package \code{\link{gsDesign}}; or a user supplied spending function.}

\item{...}{not used argument.}
}
\value{
An object of class "dec.table" is a list containing:
 \item{table}{the generated decision table.}
 \item{alpha.two}{a vector of true type 1 error for two-tailed test.}
 \item{E}{a vector of "E" bound.}
 \item{D}{a vector of "D" bound.}
 \item{DU}{a vector of "DU" bound.}
 \item{pc}{input; a vector of target toxicity}
 \item{pc.u}{input; a vector of target toxicity }
 \item{n}{input; a vector with sample size at each stage.}
 \item{sf}{input; the alpha-spending function used.}
}
\description{
Generate three stage dose finding decision table
}
\details{
Alpha-spending method is added to two-/three-stage designs. \code{dec.table} supports two spending functions : \code{Pocock} and \code{OF}. See details in \code{\link{gsDesign}}.
}
\examples{
alpha.l <- 0.6
alpha.r <- 0.4
alpha.u <- 0.3
pc <- c(0.29, 0.31)
pc.u <- 0.3
# print out decision table for a 3+3+3 design 
n <- rep(3, 3)
dec.table(alpha.l, alpha.r, alpha.u, pc, pc.u, n)$table
# 3+3 design
n <- rep(3, 2)
 dec.table(alpha.l, alpha.r, alpha.u, pc, pc.u, n)$table
}
\author{
Wenchuan Guo <wguo007@ucr.edu>
}
