% Generated by roxygen2 (4.0.2): do not edit by hand
\name{f.rosenbrock}
\alias{df.rosenbrock}
\alias{f.rosenbrock}
\alias{hess.rosenbrock}
\title{Multivariate Rosenbrock function, derivative, Hessian}
\usage{
f.rosenbrock(V)

df.rosenbrock(V)

hess.rosenbrock(V)
}
\arguments{
\item{V}{Vector of length 2N, ordered \eqn{(x_1,y_1,x_2,y_2,\mathellipsis, x_N,y_N)}}
}
\value{
\describe{
\item{f.rosenbrock}{a scalar value of the objective function}
\item{df.rosenbrock}{a numeric vector for the gradient of the function.}
\item{hess.rosenbrock}{a symmetric matrix of class \code{dgCMatrix} (defined
    in the \pkg{Matrix} package) for the Hessian of the function.}
}
}
\description{
Objective function, gradient and hessian for demos.
}
\details{
The objective function is:
\deqn{
 f(x_{1:N},y_{1:N})=\sum_{i=1}^N
\left[100\left(x^2_i-y_i\right)^2+\left(x_i-1\right)^2\right]
}
These functions are provided for the examples and demos in the
\pkg{trustOptim} package.
}

