% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropicalsparse.doti.R
\name{tropicalsparse.doti}
\alias{tropicalsparse.doti}
\title{tropicalsparse.doti()}
\usage{
tropicalsparse.doti(x, y, algebraType)
}
\arguments{
\item{x}{is a vector.}

\item{y}{is a vector.}

\item{algebraType}{is string input that can be \code{minplus} or \code{maxplus}.}
}
\value{
Returns a vector.
}
\description{
\code{tropicalsparse.doti} function multiplies the vector \code{y} with the vector \code{x}.
}
\details{
The input of this function is \code{x}, \code{y} and \code{algebraType}. If any of the input is missing
then the function generates an error. The operation is expressed as: result = yx where \code{x} and \code{y}
must be a vector. \code{algebraType} is used to specify type of Tropical Algebra. This can be \code{minplus} or
\code{maxplus}. For more details about \code{algebraType}, see \code{detail} section of
\code{\link{check.infinityM}} or \code{\link{check.infinityV}}.
}
\examples{
a <- c(2, Inf, 5, 0, Inf, Inf, Inf, 10, Inf)
b <- c(0, 5, Inf, Inf, 12, 2, Inf, Inf, 3)

tropicalsparse.doti(a, b, 'minplus')

# [1]   2 Inf Inf Inf Inf Inf Inf Inf Inf

}
\seealso{
\code{\link{tropicalsparse.axpyi}}
}
