% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crm_codified_dose_logistic.R
\name{crm_codified_dose_logistic}
\alias{crm_codified_dose_logistic}
\title{Calculate codified CRM doses.}
\usage{
crm_codified_dose_logistic(prob_tox, alpha_mean, beta_mean)
}
\arguments{
\item{prob_tox}{Numeric vector, seek codified doses that yield these
probabilities of toxicity.}

\item{alpha_mean}{Numeric, expected value of intercept.}

\item{beta_mean}{Numeric, expected value of gradient with respect to dose.}
}
\value{
Numeric vector of codified doses.
}
\description{
Calculate the codified CRM doses that map to probability of
toxicity \code{prob_tox} in a logistic model with expected values for
intercept and gradient. I.e. find \eqn{x[i]} such that
\eqn{logit(p[i]) = \alpha + \beta x[i]}, were \eqn{p} is
\code{prob_tox}.
}
\examples{
skeleton <- c(0.05, 0.1, 0.2, 0.5)
crm_codified_dose_logistic(skeleton, 1, 0)
crm_codified_dose_logistic(skeleton, 3, 0.5)
}
