% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wedge.R
\name{wedge}
\alias{wedge}
\title{Performs the wedge operation}
\usage{
wedge(A, B)
}
\arguments{
\item{A, B}{two real coefficient matrices, complex coefficient vectors or phylo objects}
}
\value{
the wedge result in the same form as the arguments
}
\description{
Calculates the result from the wedge operation on two real coefficient
matrices, two complex coefficient vectors or two phylo objects.
}
\examples{

library(treenomial)
library(ape)

# wedge two real coefficient matrices

leaf <- matrix(c(0,1), nrow = 1, ncol = 2)
wedge(leaf, leaf)

# wedge two complex coefficient vectors

leaf <- as.complex(c(0,1))
wedge(leaf, leaf)

}
