% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforest.R
\name{rforest}
\alias{rforest}
\title{Random forest}
\usage{
rforest(X, y, mtry = NULL, ntree = 500, rotate = FALSE, ...)
}
\arguments{
\item{X}{A data frame or a matrix of predictors.}

\item{y}{Numeric vector of response value. For binary outcomes, \code{y} 
should be mapped to \{0, 1\}. Note that multiclass outcomes are not supported.}

\item{mtry}{Integer specifying the number of variables randomly sampled as 
candidates splitters at each node in a tree. Note that the default values are 
different for classification (\code{floor(sqrt(p))} where \code{p} is number 
of columns of \code{X}) and regression \code{floor(p/3)}).}

\item{ntree}{Integer specifying the number of trees to grow. This should not 
be set to too small a number, to ensure that every input row gets predicted 
at least a few times. Default is \code{500}.}

\item{rotate}{Logical indicating whether or not to randomly rotate the 
feature values prior to fitting each tree. Default is \code{FALSE} which
results in a traditional random forest.}

\item{...}{Optional arguments to be passed on to 
\code{\link[randomForest]{randomForest}} (e.g., \code{nodesize = 10}).}
}
\value{
An object of class \code{"rforest"}, which is essentially a list of
\link{rftree} objects.
}
\description{
A poor man's implementation of random forest (Breiman, 2001) with the option
to incorporate random rotations as described in Blaser and Fryzlewicz (2016).
}
\references{
Breiman, Leo. (2001), Random Forests, Machine Learning 45(1), 5-32.

Rico Blaser and Piotr Fryzlewicz. Random rotation ensembles. Journal of 
Machine Learning Research, 17:1–26, 2016.
}
