% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiC2Tree.R
\name{clusterTree}
\alias{clusterTree}
\title{Create hierarchical clustering trees for each cluster in a given
matrix}
\usage{
clusterTree(mat)
}
\arguments{
\item{mat}{A matrix containing the data to cluster. It should have columns
named 'index1', 'index2', 'chromosome and one column for each matrices.}
}
\value{
A list containing the following objects:
\describe{
  \item{trees}{ A list of hierarchical clustering trees, one for each cluster
  in the matrix.}
  \item{metadata}{ A data frame containing the following columns: names (name
  of each tree), chromosome, cluster, and file. }
}
}
\description{
This function creates a hierarchical clustering tree for each
group in a given matrix. The function breaks the chromosome into clusters
using the "broken stick" method and then converts the clusters into trees.
}
\examples{
n <- 5

matrice <- matrix(runif(n*n), nrow = n, ncol = n)
matrice[lower.tri(matrice)] <- t(matrice)[lower.tri(matrice)]
matrice <- as.data.frame(matrice)
names(matrice) <- c("mat_1", "mat_2", "mat_3", "mat_4", "mat_5")

chromosome <- rep(1, n)
index1 <- sample(1:100, n, replace = TRUE)
index2 <- sample(1:100, n, replace = TRUE)

mat <- cbind(chromosome, index1, index2, matrice)

res <- clusterTree(mat)
}
