% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{boundaries}
\alias{boundaries}
\title{Boundaries of the German National Inventory 2022}
\format{
A data frame with 148 observations on the following 13 variables.
Variables not needed with the package are marked with an asterisk.
  \describe{
    \item{\code{tnr}}{The tract id.}
    \item{\code{enr}}{The corner id. A tract may have up to 4 corners on
    wooden floor.}
    \item{\code{vbl}}{* An indicator giving the country. 804 denotes
    Baden-Wuerttemberg.}
    \item{\code{rnr}}{* The boundary id.}
    \item{\code{rk}}{An indicator giving the validity of the boundary. Values
    of 9 or higher indicate that this boundary is not valid (any more).}
    \item{\code{rart}}{An indicator giving the type of the boundary (stand or
    forest boundary, for example).}
    \item{\code{rterrain}}{* An Indicator giving the type of terrain behind
    the border.}
    \item{\code{spa_gon}}{The azimuth in gon of the starting point of the
    boundary.}
    \item{\code{spa_m}}{The distance to the starting point of the boundary in
    centimeter}
    \item{\code{spk_gon}}{As above, for the boundary's flexing point.}
    \item{\code{spk_m}}{As above, for the boundary's flexing point.}
    \item{\code{spe_gon}}{As above, for the boundary's stopping point.}
    \item{\code{spe_m}}{As above, for the boundary's stopping point.}
  }
}
\usage{
data("boundaries", package = "treePlotArea")
}
\description{
An extract from the the federal database. Refer to \emph{Aufnahmeanweisung
für die vierte Bundeswaldinventur (2021 - 2022)}.
}
\examples{
boundaries <- get(data("boundaries", package = "treePlotArea"))
}
\references{
\cite{
Aufnahmeanweisung für die vierte Bundeswaldinventur (2021 - 2022)
Johann Heinrich von Thünen-Institut. Bundesforschungseinheit für
Ländliche Räume, Wald und Fischerei, Thünen-Institut für
Waldökologie.
}
}
\keyword{datasets}
