% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.r
\name{normalize}
\alias{normalize}
\title{Normalize a Numeric Vector}
\usage{
normalize(x, method = c("min_max", "z_score"))
}
\arguments{
\item{x}{A numeric or integer vector to be normalized.}

\item{method}{A character string specifying the normalization method. Options
are \code{"min_max"} for min-max normalization or \code{"z_score"} for z-score
normalization. If no method is provided, the default is \code{"min_max"}.}
}
\value{
A numeric vector of the same length as \code{x}, containing the
normalized values.
}
\description{
This function normalizes a numeric or integer vector using one of two
methods: min-max normalization (scales data to the range (0, 1)) or z-score
normalization (centers data around 0 with a standard deviation of 1).
}
\examples{
# Example data
data <- c(10, 20, 30, 40, 50, NA)

# Min-max normalization
normalize(data, method = "min_max")

# Z-score normalization
normalize(data, method = "z_score")

# Default behavior (min-max normalization)
normalize(data)

}
\author{
Nicolas Foss, Ed.D., MS
}
