% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeMissings.R
\name{computeMiss}
\alias{computeMiss}
\title{Displays whether a variable contains missing values}
\usage{
computeMiss (x, variable = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class "xpssFrame".}

\item{variable}{atomic character with the name of the variable.}
}
\value{
atomic logical with the length of the data. Returns \code{TRUE},
if the variable contains a system- or user-defined missing value.
}
\description{
R Implementation of the SPSS \code{Missing} Function.
}
\details{
Performs a missing value operation. \code{ComputeMiss} displays system- and user-defined missing values of variables.
The different missing types will be inspected without checking if they are system-; or user-defined missings.

\code{variable} input is limited to only one variable.
}
\examples{
data(fromXPSS)

xpssCompute(x=fromXPSS, variables="V7_2",fun="computeMiss")
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{computeNmiss}} , \code{\link{computeNvalid}} , \code{\link{computeSysmis}} ,\code{\link{computeValue}}
}
\keyword{internal}

