% Generated by roxygen2 (4.0.1): do not edit by hand
\name{aGroup}
\alias{aGroup}
\title{A box container. Packs in items left to right or top to bottom}
\usage{
aGroup(..., horizontal = TRUE, spacing = 10, context = NULL,
  attr = list(), enabled_when, visible_when)
}
\arguments{
\item{horizontal}{If \code{TRUE} left to right, if \code{FALSE} top to bottom}

\item{spacing}{Space in pixels between items}

\item{context}{ItemGroup or item to get context from. Typically just NULL.}

\item{attr}{gWidget values passed to constructor}

\item{enabled_when}{Method to determine when items in container should be enabled}

\item{visible_when}{Method to determine when items in container should be visible}

\item{...}{children items specified by character strings}
}
\value{
Returns a \code{proto} object. Call \code{obj$show_help()} to view its methods and properties.
}
\description{
A box container. Packs in items left to right or top to bottom
}
\examples{
i <- aDialog(items=list(xlong=numericItem(1), y=stringItem("a")))
lay <- aGroup("xlongname","y", horizontal=FALSE)  # not in nice layout
\dontrun{i$make_gui(gui_layout=lay)}
}
\seealso{
\code{\link{Container}}
}

