% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.metadata.R
\name{as.metadata}
\alias{as.metadata}
\title{Create metadata for trait dataset}
\usage{
as.metadata(
  ...,
  template = list(datasetID = NULL, datasetName = NULL, author = NULL, rightsHolder =
    NULL, bibliographicCitation = NULL, license = NULL, version = NULL, comments = NULL,
    description = NULL, region = NULL)
)
}
\arguments{
\item{...}{named objects of any class. Names must be the same as given by template or they will be ignored when producing the metadata object.}

\item{template}{The default template contains the elements as defined by the Ecological Traitdata Standard. (see Details)}
}
\value{
an object of class 'metadata', or - if metadata objects are provided as input - a list object of class 'metadatalist'.
}
\description{
Function to create a defined object containing metadata paramaters according to a pre-defined template.
}
\examples{

# set metadata object
a <- as.metadata(author = "Martin Gossner", datasetName = "Heteroptera morphometric traits")

# update an existing metadata object
a1 <- as.metadata(datasetID = "heteroptera", template = a)

}
