% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{threadSafeTempFile}
\alias{threadSafeTempFile}
\title{Obtain thread-safe temporary file names}
\usage{
threadSafeTempFile(pattern = "file")
}
\arguments{
\item{pattern}{Character vector giving the initial part of each file name.}
}
\value{
A character vector of temporary file names. No files are actually
  created.
}
\description{
This function is a wrapper around \code{\link{tempfile}}, which creates
temporary file names whose path contains the process ID of the calling
process. This avoids clashes between threads created by functions such as
\code{mclapply} (in the ``parallel'' package), which can easily occur with
the standard \code{\link{tempfile}} function.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{http://www.jstatsoft.org/v44/i08/}.
}
\seealso{
\code{\link{tempfile}}
}
\author{
Jon Clayden
}
