% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata.R
\name{GC2trackeRdata}
\alias{GC2trackeRdata}
\title{Coercion function for use in Golden Cheetah}
\usage{
GC2trackeRdata(
  gc,
  cycling = TRUE,
  correct_distances = FALSE,
  country = NULL,
  mask = TRUE,
  from_distances = FALSE,
  lgap = 30,
  lskip = 5,
  m = 11,
  silent = FALSE
)
}
\arguments{
\item{gc}{Output of \code{GC.activity}.}

\item{cycling}{Logical. Does the data stem from cycling?}

\item{correct_distances}{Logical. Should the distances be corrected
for elevation? Default is \code{FALSE}.}

\item{country}{ISO3 country code for downloading altitude data. If
\code{NULL}, country is derived from longitude and latitude}

\item{mask}{Logical. Passed on to
\code{\link[raster]{getData}}. Should only the altitudes for
the specified \code{country} be extracted (\code{TRUE}) or also
those for the neighbouring countries (\code{FALSE})?}

\item{from_distances}{Logical. Should the speeds be calculated from the distance recordings
instead of taken from the speed recordings directly?}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{silent}{Logical. Should warnings be generated if any of the
sanity checks on the data are triggered?}
}
\description{
Coercion function for use in Golden Cheetah
}
\seealso{
\code{\link{trackeRdata}}
}
