% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_plot.R, R/zzz_aliases.R
\name{plot_route}
\alias{plot_route}
\alias{plotRoute}
\title{Plot routes for training sessions}
\usage{
plot_route(x, session = 1, zoom = NULL, speed = TRUE, threshold = TRUE,
  mfrow = NULL, ...)

plotRoute(x, session = 1, zoom = NULL, speed = TRUE, threshold = TRUE,
  mfrow = NULL, ...)
}
\arguments{
\item{x}{A object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be plotted. Defaults
to the first session, all sessions can be plotted by \code{session = NULL}.}

\item{zoom}{The zoom level for the background map as passed on to
\code{\link[ggmap]{get_map}} (2 corresponds roughly to continent
level and 20 to building level).}

\item{speed}{Logical. Should the trace be colored according to speed?}

\item{threshold}{Logical. Should thresholds be applied?}

\item{mfrow}{A vector of 2 elements, number of rows and number of columns,
specifying the layout for multiple sessions.}

\item{...}{Additional arguments passed on to \code{\link{threshold}} and
\code{\link[ggmap]{get_map}}, e.g., \code{source} and \code{maptype}.}
}
\description{
Plot the route ran/cycled during training onto a background map.
Internet connection is required to download the background map.
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
plotRoute(runs, session = 4, zoom = 13)
plotRoute(runs, session = 4, zoom = 13, maptype = "hybrid")
## multiple sessions
plotRoute(runs, session = c(1:5, 8:11), source = "google")
## different zoom level per panel
plotRoute(runs, session = 6:7, source = "google", zoom = c(13, 14))
}
}
\seealso{
\code{\link[ggmap]{get_map}}, \code{\link[ggmap]{ggmap}}
}
