% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcPCA.R, R/trackeR.R
\name{funPCA}
\alias{funPCA}
\alias{funPCA.distrProfile}
\alias{funPCA.conProfile}
\alias{funPCA}
\title{Functional principal components analysis of distribution or concentration profiles.}
\usage{
\method{funPCA}{distrProfile}(object, what, nharm = 4, ...)

\method{funPCA}{conProfile}(object, what, nharm = 4, ...)

funPCA(object, ...)
}
\arguments{
\item{object}{The object to which a functional principal components analysis is applied.}

\item{what}{The variable for which the profiles should be analysed.}

\item{nharm}{The number of principal components estimated.}

\item{...}{Arguments to be passed to methods.}
}
\value{
An object of class \code{trackeRfpca}.
}
\description{
Functional principal components analysis of distribution or concentration profiles.

Generic function for functional principal components analysis.
}
\details{
The \code{...} argument is passed on to \code{\link[fda]{pca.fd}}.
}
\examples{
data("runs", package = "trackeR")
dp <- distributionProfile(runs, what = "speed")
dp.pca <- funPCA(dp, what = "speed", nharm = 4)
## 1st harmonic  captures vast majority of the variation
plot(dp.pca, harm = 1)
## time spent above speed = 0 is the characteristic distinguishing the profiles
sumRuns <- summary(runs)
plot(sumRuns$durationMoving, dp.pca$scores[,1])
}
\references{
Ramsay JO, Silverman BW (2005). Functional Data Analysis. Springer-Verlag New York.
}
