% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txpExportGui.R
\name{txpExportGui}
\alias{txpExportGui}
\title{Export comma-separated file intended for ToxPi GUI}
\usage{
txpExportGui(
  fileName = "txpModel.csv",
  input,
  model,
  id.var = NULL,
  fills = NULL
)
}
\arguments{
\item{fileName}{Character scalar, the path to the output file}

\item{input}{data.frame object containing the model input data}

\item{model}{\link{TxpModel} object or \link{TxpModelList} object}

\item{id.var}{Character scalar, column in 'input' to store in}

\item{fills}{Colors to fill the slices}
}
\description{
Export comma-separated file intended for ToxPi GUI
}
\details{
The GUI differs in two meaninful ways for exporting \code{toxpiR} models: (1) the
GUI only allows for integer weights; (2) the GUI applies transformation
functions differently.

\code{txpExporGui} will not work for models with non-integer weights.

The GUI only applies a single transformation function to every input within
a slice, and only functions from a pre-determined list; \code{toxpiR} allows
users to apply any valid function individually to each input, then a second
transformation function on the summed slice values. Because of this
complexity, any exported models with slice-level transformation functions
will not export at the input level. In other words, the export will have only
the final slice scores. Otherwise, all input-level transformations will be
performed, the and the export will contain transformed input-level data with
the \code{linear(x)} GUI transformation.
}
