% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMap.R
\name{make_tox_map}
\alias{make_tox_map}
\alias{map_tox_data}
\title{Create an interactive map of the data}
\usage{
make_tox_map(chemical_summary, chem_site, category = "Biological",
  mean_logic = FALSE, sum_logic = TRUE)

map_tox_data(chemical_summary, chem_site, category = "Biological",
  mean_logic = FALSE, sum_logic = TRUE)
}
\arguments{
\item{chemical_summary}{Data frame from \code{\link{get_chemical_summary}}.}

\item{chem_site}{Data frame containing the columns SiteID, site_grouping, 
Short Name, dec_lon, and dec_lat.}

\item{category}{Character. Either "Biological", "Chemical Class", or "Chemical".}

\item{mean_logic}{Logical.  \code{TRUE} displays the mean EAR from each site,
\code{FALSE} displays the maximum EAR from each site.}

\item{sum_logic}{Logical. \code{TRUE} sums the EARs in a specified grouping,
\code{FALSE} does not. \code{FALSE} may be better for traditional benchmarks as
opposed to ToxCast benchmarks.}
}
\description{
The function \code{make_tox_map} creates a \code{\link[leaflet]{leaflet}} map 
of the sites. This function places symbols at the location of each site in the data 
file that represent the magnitude of EAR (color) and the number of 
samples in the data set (size). This is the only function that requires 
"dec_lon" and "dec_lat" (decimal longitude and decimal latitude) in the 
data frame specified for the chem_site argument.
}
\details{
The function \code{map_tox_data} calculates the statistics for the map. It
my be useful on it's own.
}
\examples{
# This is the example workflow:
path_to_tox <-  system.file("extdata", package="toxEval")
file_name <- "OWC_data_fromSup.xlsx"

full_path <- file.path(path_to_tox, file_name)
tox_list <- create_toxEval(full_path)

ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)
chemical_summary <- get_chemical_summary(tox_list, ACC, filtered_ep)

make_tox_map(chemical_summary, tox_list$chem_site, "Biological")   
make_tox_map(chemical_summary, tox_list$chem_site, "Chemical Class")
make_tox_map(chemical_summary, tox_list$chem_site, "Chemical") 

}
