% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-sage.R
\name{display_sage}
\alias{display_sage}
\alias{animate_sage}
\title{Display tour path with a sage scatterplot}
\usage{
display_sage(
  axes = "center",
  half_range = NULL,
  col = "black",
  pch = 20,
  gam = 1,
  R = NULL,
  ...
)

animate_sage(data, tour_path = grand_tour(), ...)
}
\arguments{
\item{axes}{position of the axes: center, bottomleft or off}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{col}{color to be plotted.  Defaults to "black"}

\item{pch}{marker for points. Defaults to 20.}

\item{gam}{scaling of the effective dimensionality for rescaling. Defaults to 1.}

\item{R}{scale for the radial transformation.
If not set, defaults to maximum distance from origin to each row of data.}

\item{...}{other arguments passed on to \code{\link{animate}} and
\code{\link{display_sage}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}
}
\description{
Animate a 2D tour path with a sage scatterplot that
uses a radial transformation on the projected points to re-allocate
the volume projected across the 2D plane.
}
\examples{
# Generate uniform samples in a 10d sphere using the geozoo package
sphere10 <- geozoo::sphere.solid.random(10)$points
# Columns need to be named before launching the tour
colnames(sphere10) <- paste0("x", 1:10)
# Standard grand tour display, points cluster near center
animate_xy(sphere10)
# Sage display, points are uniformly distributed across the disk
animate_sage(sphere10)
}
