% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bird-species.R
\name{bird_species_dataset}
\alias{bird_species_dataset}
\title{Bird species dataset}
\usage{
bird_species_dataset(
  root,
  token = NULL,
  split = "train",
  download = FALSE,
  ...
)
}
\arguments{
\item{root}{path to the data location}

\item{token}{a path to the json file obtained in Kaggle. See \href{https://pins.rstudio.com/articles/boards-kaggle.html}{here}
for additional info.}

\item{split}{train, test or valid}

\item{download}{wether to download or not}

\item{...}{other arguments passed to \code{\link[torchvision:image_folder_dataset]{torchvision::image_folder_dataset()}}.}
}
\value{
A \code{\link[torch:dataset]{torch::dataset()}} ready to be used with dataloaders.
}
\description{
Prepares the bird species dataset available in Kaggle \href{https://www.kaggle.com/gpiosenka/100-bird-species}{here}
}
\details{
We use pins for downloading and managing authetication.
If you want to download the dataset you need to register the Kaggle board as
described in \href{https://pins.rstudio.com/articles/boards-kaggle.html}{this link}.
or pass the \code{token} argument.
}
\examples{
if (torch::torch_is_installed() && FALSE) {
birds <- bird_species_dataset("./data", token = "path/to/kaggle.json",
                              download = TRUE)
length(birds)
}
}
