% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{get_grid}
\alias{get_grid}
\title{Create Grid Around Maximum Likelihood Estimate (Internal)}
\usage{
get_grid(samples, param, num_points, start_factor, end_factor)
}
\arguments{
\item{samples}{Data frame of parameter samples with an NLL column.}

\item{param}{Character name of the parameter column.}

\item{num_points}{Integer number of points for the grid.}

\item{start_factor}{Numeric factor for grid's lower boundary relative to MLE.}

\item{end_factor}{Numeric factor for grid's upper boundary relative to MLE.}
}
\value{
A numeric vector of grid points.
}
\description{
Internal helper to generate a sequence of values for a parameter. The grid is
centered on the parameter's Maximum Likelihood Estimate (MLE), which is found
by calculating the mode of its weighted marginal distribution.
}
\keyword{internal}
