% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_tokens.r
\name{highlight_tokens}
\alias{highlight_tokens}
\title{Highlight tokens}
\usage{
highlight_tokens(
  tokens,
  value,
  class = NULL,
  col = "yellow",
  unfold = NULL,
  span_adjacent = F,
  doc_id = NULL
)
}
\arguments{
\item{tokens}{A character vector of tokens}

\item{value}{Either a logical vector or a numeric vector with values between 0 and 1.
If a logical vector is used, then tokens with TRUE will be highlighted (with the color specified in pos_col).
If a numeric vector is used, the value determines the alpha (transparency), with 0 being fully transparent
and 1 being fully colored.}

\item{class}{Optionally, a character vector of the class to add to the span tags. If NA no class is added}

\item{col}{The color used to highlight}

\item{unfold}{Either a character vector or a named list of vectors of the same length as tokens. If given, all tokens with a tag can be clicked on to unfold the given text. If a list of vectors is given,
the values of the columns are concatenated with the column name. E.g. list(doc_id = 1, sentence = 1) will be [doc_id = 1, sentence = 2].
This only works if the tagged tokens are used in the html browser created with the \code{\link{create_browser}} function (as it relies on javascript).}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}

\item{doc_id}{If span_adjacent is TRUE, The document ids are required to ensure that tags do not span from one document to another.}
}
\value{
a character vector of color-tagged tokens
}
\description{
This is a convenience wrapper for tag_tokens() that can be used if tokens only need to be colored.
}
\examples{
highlight_tokens(c('token_1','token_2','token_3'),
                 value = c(FALSE,FALSE,TRUE))

highlight_tokens(c('token_1','token_2','token_3'),
                 value = c(0,0.3,0.6))
}
