% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importexport.R
\name{tmod2DataFrame}
\alias{tmod2DataFrame}
\title{Convert a tmod module set into a data frame}
\usage{
tmod2DataFrame(
  mset,
  rows = "modules",
  module_col = "module_id",
  feature_col = "feature_id",
  sep = ","
)
}
\arguments{
\item{mset}{a tmod object (e.g. generated by makeTmod)}

\item{rows}{if "modules", then there will be a row corresponding to each
module (gene set); if "features", then there will be a row corresponding to
each gene.}

\item{module_col}{Name of the column with module (gene set) IDs}

\item{feature_col}{Name of the column with feature (gene) IDs}

\item{sep}{separator used to collate module IDs (if rows=="features") or feature IDs (if rows=="modules")}
}
\description{
Convert a tmod module set into a data frame
}
\seealso{
\code{\link{tmod-class}}, \code{\link{makeTmod}}
}
