% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_spineplot.R
\name{type_spineplot}
\alias{type_spineplot}
\title{Spineplot and spinogram types}
\usage{
type_spineplot(
  breaks = NULL,
  tol.ylab = 0.05,
  off = NULL,
  ylevels = NULL,
  col = NULL,
  xaxlabels = NULL,
  yaxlabels = NULL,
  weights = NULL
)
}
\arguments{
\item{breaks}{if the explanatory variable is numeric, this controls how
    it is discretized. \code{breaks} is passed to \code{\link[graphics]{hist}} and can
    be a list of arguments.}

\item{tol.ylab}{convenience tolerance parameter for y-axis annotation.
    If the distance between two labels drops under this threshold, they are
    plotted equidistantly.}

\item{off}{vertical offset between the bars (in per cent). It is fixed to
    \code{0} for spinograms and defaults to \code{2} for spine plots.}

\item{ylevels}{a character or numeric vector specifying in which order
    the levels of the dependent variable should be plotted.}

\item{col}{a vector of fill colors of the same length as \code{levels(y)}.
    The default is to call \code{\link{gray.colors}}.}

\item{xaxlabels, yaxlabels}{character vectors for annotation of x and y axis.
    Default to \code{levels(y)} and \code{levels(x)}, respectively for the
    spine plot. For \code{xaxlabels} in the spinogram, the breaks are
    used.}

\item{weights}{numeric. A vector of frequency weights for each
    observation in the data. If \code{NULL} all weights are implicitly
    assumed to be 1. If \code{x} is already a 2-way table, the weights
    are ignored.}
}
\description{
Type function(s) for producing spineplots and spinograms, which
are modified versions of histograms or mosaic plots, and particularly
useful for visualizing factor variables. Note that \code{\link{tinyplot}} defaults
to \code{type_spineplot()} if \code{y} is a factor variable.
}
\examples{
# "spineplot" type convenience string
tinyplot(Species ~ Sepal.Width, data = iris, type = "spineplot")

# Aside: specifying the type is redundant for this example, since tinyplot()
# defaults to "spineplot" if y is a factor (just like base plot).
tinyplot(Species ~ Sepal.Width, data = iris)

# Use `type_spineplot()` to pass extra arguments for customization
tinyplot(Species ~ Sepal.Width, data = iris, type = type_spineplot(breaks = 4))

p = palette.colors(3, "Pastel 1")
tinyplot(Species ~ Sepal.Width, data = iris, type = type_spineplot(breaks = 4, col = p))
rm(p)

# More idiomatic tinyplot way of drawing the previous plot: use y == by
tinyplot(
  Species ~ Sepal.Width | Species, data = iris, type = type_spineplot(breaks = 4),
  palette = "Pastel 1", legend = FALSE
)

# Grouped and faceted spineplots

ttnc = as.data.frame(Titanic)

tinyplot(
  Survived ~ Sex, facet = ~ Class, data = ttnc,
  type = type_spineplot(weights = ttnc$Freq)
)

# For grouped "by" spineplots, it's better visually to facet as well
tinyplot(
  Survived ~ Sex | Class, facet = "by", data = ttnc,
  type = type_spineplot(weights = ttnc$Freq)
)

# Fancier version. Note the smart inheritance of spacing etc.
tinyplot(
  Survived ~ Sex | Class, facet = "by", data = ttnc,
  type = type_spineplot(weights = ttnc$Freq),
  palette = "Dark 2", facet.args = list(nrow = 1), axes = "t"
)

# Note: It's possible to use "by" on its own (without faceting), but the
# overlaid result isn't great. We will likely overhaul this behaviour in a
# future version of tinyplot...
tinyplot(Survived ~ Sex | Class, data = ttnc,
  type = type_spineplot(weights = ttnc$Freq), alpha = 0.3
)

}
