% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_truth.R
\name{str_truth}
\alias{str_truth}
\alias{\%s{}\%}
\alias{\%s!{}\%}
\title{'stringi' Pattern Detection Operators}
\usage{
x \%s{}\% p

x \%s!{}\% p
}
\arguments{
\item{x}{a string or character vector.}

\item{p}{either a list with 'stringi' arguments (see \link{s_regex}),
or else a character vector of the same length as \code{x} with regular expressions. \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_regex.html}{\figure{aboutsearch-regex-darkred.svg}{options: alt='[REGEX]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_regex.html}{about search: regex}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_fixed.html}{\figure{aboutsearch-fixed-darkgreen.svg}{options: alt='[FIXED]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_fixed.html}{about search: fixed}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_coll.html}{\figure{aboutsearch-coll-pink.svg}{options: alt='[COLL]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_coll.html}{about search: coll}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_charclass.html}{\figure{aboutsearch-charclass-lightyellow.svg}{options: alt='[CHARCLASS]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_charclass.html}{about search: charclass}} \cr}
}
\value{
The \code{x \%s{}\% p} and \code{x \%s!{}\% p} operators
return logical vectors, where \code{TRUE} indicates a pattern was found,
and \code{FALSE} indicates a pattern was not found. \cr
}
\description{
The \code{x \%s{}\% p} operator
checks for every string in character vector \code{x} if
the pattern defined in \code{p} is present. \cr
\cr
The \code{x \%s!{}\% p} operator
checks for every string in character vector \code{x} if
the pattern defined in \code{p} is NOT present. \cr
}
\examples{

# simple pattern ====

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
x \%s{}\% "a"
x \%s!{}\% "a"
which(x \%s{}\% "a")
which(x \%s!{}\% "a")
x[x \%s{}\% "a"]
x[x \%s!{}\% "a"]
x[x \%s{}\% "a"] <- 1
x[x \%s!{}\% "a"] <- 1
print(x)

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
x \%s{}\% "1"
x \%s!{}\% "1"
which(x \%s{}\% "1")
which(x \%s!{}\% "1")
x[x \%s{}\% "1"]
x[x \%s!{}\% "1"]
x[x \%s{}\% "1"] <- "a"
x[x \%s!{}\% "1"] <- "a"
print(x)


#############################################################################

# ignore case pattern ====


x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
p <- list(regex = c("A", "A"), case_insensitive=TRUE)
x \%s{}\% p
x \%s!{}\% p
which(x \%s{}\% p)
which(x \%s!{}\% p)
x[x \%s{}\% p]
x[x \%s!{}\% p]
x[x \%s{}\% p] <- "hello"
x[x \%s!{}\% p] <- "hello"
print(x)


#############################################################################

# multi-character pattern ====

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
p <- list(regex = rep("AB", 2), case_insensitive=TRUE)
x \%s{}\% p
x \%s!{}\% p
which(x \%s{}\% p)
which(x \%s!{}\% p)
x[x \%s{}\% p]
x[x \%s!{}\% p]
x[x \%s{}\% p] <- "CD"
x[x \%s!{}\% p] <- "CD"
print(x)



}
\seealso{
\code{\link[=tinycodet_strings]{tinycodet_strings()}}
}
