% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ozonate_bromate.R
\name{ozonate_bromate}
\alias{ozonate_bromate}
\title{Calculate bromate formation}
\source{
Ozekin (1994), Sohn et al (2004), Song et al (1996), Galey et al (1997), Siddiqui et al (1994)

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
ozonate_bromate(water, dose, time, model = "Ozekin")
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}}

\item{dose}{Applied ozone dose (mg/L as O3). Results typically valid for 1-10 mg/L, but varies depending on model.}

\item{time}{Reaction time (minutes). Results typically valid for 1-120 minutes, but varies depending on model.}

\item{model}{Model to apply. One of c("Ozekin", "Sohn", "Song", "Galey", "Siddiqui")}
}
\value{
A water class object with calculated bromate (ug/L).
}
\description{
Calculates bromate (BrO3-, ug/L) formation based on selected model. Required arguments include an object of class "water"
created by \code{\link{define_water}} ozone dose, reaction time, and desired model.
The function also requires additional water quality parameters defined in \code{define_water}
including bromide, DOC or UV254 (depending on the model), pH, alkalinity (depending on the model), and
optionally, ammonia (added when defining water using the `tot_nh3` argument.)
}
\examples{
example_dbp <- suppressWarnings(define_water(8, 20, 66, toc = 4, uv254 = .2, br = 50)) \%>\%
  ozonate_bromate(dose = 1.5, time = 5, model = "Ozekin")
example_dbp <- suppressWarnings(define_water(7.5, 20, 66, toc = 4, uv254 = .2, br = 50)) \%>\%
  ozonate_bromate(dose = 3, time = 15, model = "Sohn")

}
