% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_gtfs}
\alias{read_gtfs}
\title{Read and validate GTFS files}
\usage{
read_gtfs(path, files = NULL, quiet = TRUE)
}
\arguments{
\item{path}{The path to a GTFS \code{.zip} file.}

\item{files}{A character vector containing the text files to be read from the
GTFS (without the \code{.txt} extension). If \code{NULL} (the default) all
existing files are read.}

\item{quiet}{Whether to hide log messages and progress bars (defaults to TRUE).}
}
\value{
A tidygtfs object: a list of tibbles in which each entry represents a
GTFS text file. Additional tables are stored in the \code{.} sublist.
}
\description{
Reads GTFS text files from either a local \code{.zip} file or an URL and
validates them against GTFS specifications.
}
\examples{
local_gtfs_path <- system.file("extdata", "google_transit_nyc_subway.zip", package = "tidytransit")
gtfs <- read_gtfs(local_gtfs_path)
names(gtfs)

gtfs <- read_gtfs(local_gtfs_path, files = c("trips", "stop_times"))
names(gtfs)

}
\seealso{
\code{\link{validate_gtfs}}
}
