% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_regex.R
\name{unnest_regex}
\alias{unnest_regex}
\title{Wrapper around unnest_tokens for regular expressions}
\usage{
unnest_regex(
  tbl,
  output,
  input,
  pattern = "\\\\s+",
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)
}
\arguments{
\item{tbl}{A data frame}

\item{output}{Output column to be created as string or symbol.}

\item{input}{Input column that gets split as string or symbol.

The output/input arguments are passed by expression and support
\link[rlang]{quasiquotation}; you can unquote strings and symbols.}

\item{pattern}{A regular expression that defines the split.}

\item{format}{Either "text", "man", "latex", "html", or "xml". If not text,
this uses the hunspell tokenizer, and can tokenize only by "word"}

\item{to_lower}{Whether to convert tokens to lowercase. If tokens include
URLS (such as with \code{token = "tweets"}), such converted URLs may no
longer be correct.}

\item{drop}{Whether original input column should get dropped. Ignored
if the original input and new output column have the same name.}

\item{collapse}{Whether to combine text with newlines first in case tokens
(such as sentences or paragraphs) span multiple lines. If NULL, collapses
when token method is "ngrams", "skip_ngrams", "sentences", "lines",
"paragraphs", or "regex".}

\item{...}{Extra arguments passed on to \link[tokenizers]{tokenizers}}
}
\description{
This function is a wrapper around \code{unnest_tokens( token = "regex" )}.
}
\examples{
library(dplyr)
library(janeaustenr)

d <- tibble(txt = prideprejudice)

d \%>\%
  unnest_regex(word, txt, pattern = "Chapter [\\\\\\\\d]")

}
\seealso{
\itemize{
\item \code{\link[=unnest_tokens]{unnest_tokens()}}
}
}
