% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_crs.R
\name{pull_crs}
\alias{pull_crs}
\title{Extract CRS on WKT format}
\usage{
pull_crs(.data, ...)
}
\arguments{
\item{.data}{Input potentially including or representing a CRS. It could be
a \code{sf/sfc} object, a \code{SpatRaster/SpatVector} object, a \code{crs} object from
\code{\link[sf:st_crs]{sf::st_crs()}}, a character (for example a proj4 string) or a integer
(representing an EPSG code).}

\item{...}{ignored}
}
\value{
A WKT representation of the corresponding CRS.
}
\description{
Extract the WKT version of the CRS associated to a string, number of
sf/Spat* object.

The \href{https://en.wikipedia.org/wiki/Well-known_text_representation_of_coordinate_reference_systems}{Well-known text (WKT)}
representation of coordinate reference systems (CRS) is a character string
that identifies precisely the parameters of each CRS. This is the current
standard used on sf and terra packages.
}
\details{
Although the WKT representation is the same, sf and terra slightly differs.
For example, a sf user could do:

\code{sf::st_transform(x, 25830)}

While a terra user needs to:

\code{terra::project(bb, "epsg:25830")}

Knowing the WKT would help to smooth workflows when working with different
packages and object types.
}
\section{Internals}{


This is a thin wrapper of \code{\link[sf:st_crs]{sf::st_crs()}} and \code{\link[terra:crs]{terra::crs()}}.
}

\examples{

# sf objects

sfobj <- sf::st_as_sfc("MULTIPOINT ((0 0), (1 1))", crs = 4326)

fromsf1 <- pull_crs(sfobj)
fromsf2 <- pull_crs(sf::st_crs(sfobj))

# terra

v <- terra::vect(sfobj)
r <- terra::rast(v)

fromterra1 <- pull_crs(v)
fromterra2 <- pull_crs(r)

# integers
fromint <- pull_crs(4326)

# Characters
fromchar <- pull_crs("epsg:4326")


all(
  fromsf1 == fromsf2,
  fromsf2 == fromterra1,
  fromterra1 == fromterra2,
  fromterra2 == fromint,
  fromint == fromchar
)

cat(fromsf1)
}
\seealso{
\code{\link[terra:crs]{terra::crs()}}, \code{\link[sf:st_crs]{sf::st_crs()}}

Other helpers: 
\code{\link{compare_spatrasters}()},
\code{\link{is_regular_grid}()}
}
\concept{helpers}
