% Generated by roxygen2 (4.0.1): do not edit by hand
\name{unite}
\alias{unite}
\title{Unite multiple columns into one.}
\usage{
unite(data, col, ..., sep = "_", remove = TRUE)
}
\arguments{
\item{col}{(Bare) name of column to add}

\item{...}{Specification of columns to unite. Use bare variable names.
Select all variables between x and z with \code{x:z}, exclude y with
\code{-y}. For more options, see the \link[dplyr]{select} documentation.}

\item{data}{A data frame.}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}
}
\description{
Convenience function to paste together multiple functions into one.
}
\examples{
library(dplyr)
unite_(mtcars, "vs_am", c("vs","am"))

# Separate is the complement of unite
mtcars \%>\%
  unite(vs_am, vs, am) \%>\%
  separate(vs_am, c("vs", "am"))
}
\seealso{
\code{\link{separate}()}, the complement.
}

