% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tq_stock_list.R
\name{tq_index}
\alias{tq_index}
\alias{tq_exchange}
\alias{tq_index_options}
\alias{tq_exchange_options}
\title{Get all stocks in a stock index or stock exchange in \code{tibble} format}
\usage{
tq_index(x, use_fallback = FALSE)

tq_exchange(x)

tq_index_options()

tq_exchange_options()
}
\arguments{
\item{x}{A single character string, a character vector or tibble representing a
single stock index or multiple stock indexes.}

\item{use_fallback}{A boolean that can be used to return a fallback data set
last downloaded when the package was updated. Useful if the website is down.
Set to \code{FALSE} by default.}
}
\value{
Returns data in the form of a \code{tibble} object.
}
\description{
Get all stocks in a stock index or stock exchange in \code{tibble} format
}
\details{
\code{tq_index()} returns the stock symbol and company name of every stock
in an index. Eighteen stock indexes are available. The source is
\href{http://www.marketvolume.com/indexes_exchanges/}{www.marketvolume.com}.

\code{tq_index_options()} returns a list of stock indexes you can
choose from.

\code{tq_exchange()} returns the stock symbol, company, last sale price,
market capitalization, sector and industry of every stock
in an exchange. Three stock exchanges are available (AMEX, NASDAQ, and NYSE).
The source is
\href{http://www.nasdaq.com/}{NASDAQ}.

\code{tq_exchange_options()} returns a list of stock exchanges you can
choose from. The options are AMEX, NASDAQ and NYSE.
}
\examples{
# Load libraries
library(tidyquant)

# Get the list of stock index options
tq_index_options()

# Get all stock symbols in a stock index
tq_index("DOWJONES")

# Get the list of stock exchange options
tq_exchange_options()

# Get all stocks in a stock exchange
tq_exchange("NYSE")
}
\seealso{
\code{\link[=tq_get]{tq_get()}} to get stock prices, financials, key stats, etc using the stock symbols.
}
