% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indiv_inbreeding.R
\name{indiv_inbreeding}
\alias{indiv_inbreeding}
\alias{indiv_inbreeding.tbl_df}
\alias{indiv_inbreeding.vctrs_bigSNP}
\alias{indiv_inbreeding.grouped_df}
\title{Individual inbreeding coefficient}
\usage{
indiv_inbreeding(.x, method = c("WG17"), allele_sharing_mat = NULL, ...)

\method{indiv_inbreeding}{tbl_df}(.x, method = c("WG17"), allele_sharing_mat = NULL, ...)

\method{indiv_inbreeding}{vctrs_bigSNP}(.x, method = c("WG17"), allele_sharing_mat = NULL, ...)

\method{indiv_inbreeding}{grouped_df}(.x, method = c("WG17"), allele_sharing_mat = NULL, ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{method}{currently only "WG17" (for Weir and Goudet 2017).}

\item{allele_sharing_mat}{optional and only relevant for "WG17", the matrix
of Allele Sharing returned by \code{\link[=pairwise_allele_sharing]{pairwise_allele_sharing()}} with
\code{as_matrix=TRUE}. As a number of statistics can be derived from the Allele
Sharing matrix, it it sometimes more efficient to pre-compute this matrix.
It is not possible to use this with grouped tibbles.}

\item{...}{currently unused.}
}
\value{
a numeric vector of inbreeding coefficients.
}
\description{
This function calculates the inbreeding coefficient for each individual based
on the beta estimate from Weir and Goudet (2017).
}
\examples{
example_gt <- load_example_gt("gen_tbl")

example_gt \%>\% indiv_inbreeding(method = "WG17")

}
