% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{all_rows}
\alias{all_rows}
\alias{filter_rows}
\alias{max_rows}
\alias{min_rows}
\alias{first_rows}
\alias{last_rows}
\alias{sample_rows}
\title{Subset data rows}
\usage{
all_rows()

filter_rows(..., .by = NULL)

max_rows(order_by, n, by = NULL, with_ties = TRUE, na_rm = FALSE)

min_rows(order_by, n, by = NULL, with_ties = TRUE, na_rm = FALSE)

first_rows(n, by = NULL)

last_rows(n, by = NULL)

sample_rows(n, by = NULL)
}
\arguments{
\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{.data}. If multiple expressions are included, they are combined with the
\code{&} operator. Only rows for which all conditions evaluate to \code{TRUE} are
kept.}

\item{.by, by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{order_by}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variable or
function of variables to order by. To order by multiple variables, wrap
them in a data frame or tibble.}

\item{n}{The number of rows to select. If not are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group,
the result will be silently truncated to the group size.

A negative value of \code{n} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE},
may return more rows than you request. Use \code{FALSE} to ignore ties,
and return the first \code{n} rows.}

\item{na_rm}{Should missing values in \code{order_by} be removed from the result?
If \code{FALSE}, \code{NA} values are sorted to the end (like in \code{\link[dplyr:arrange]{dplyr::arrange()}}), so
they will only be included if there are insufficient non-missing values to
reach \code{n}.}
}
\value{
A \code{function} to achieve the desired data subsetting.
}
\description{
Subset data rows
}
\examples{
# Highlight all animals
animals \%>\%
 tidyplot(x = weight, y = size) \%>\%
 add_data_points() \%>\%
 add_data_points(data = all_rows(),
  color = "red", shape = 1, size = 3)

# Highlight 3 animals with the highest weight
animals \%>\%
 tidyplot(x = weight, y = size) \%>\%
 add_data_points() \%>\%
 add_data_points(data = max_rows(weight, n = 3),
  color = "red", shape = 1, size = 3)

# Highlight 3 animals with the lowest weight
animals \%>\%
 tidyplot(x = weight, y = size) \%>\%
 add_data_points() \%>\%
 add_data_points(data = min_rows(weight, n = 3),
  color = "red", shape = 1, size = 3)

# Highlight the first 3 animals in the dataset
animals \%>\%
 tidyplot(x = weight, y = size) \%>\%
 add_data_points() \%>\%
 add_data_points(data = first_rows(n = 3),
  color = "red", shape = 1, size = 3)

# Highlight the last 3 animals in the dataset
animals \%>\%
 tidyplot(x = weight, y = size) \%>\%
 add_data_points() \%>\%
 add_data_points(data = last_rows(n = 3),
  color = "red", shape = 1, size = 3)

# Highlight 3 random animals
animals \%>\%
 tidyplot(x = weight, y = size) \%>\%
 add_data_points() \%>\%
 add_data_points(data = sample_rows(n = 3),
  color = "red", shape = 1, size = 3)

}
