% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{reverse_x_axis_labels}
\alias{reverse_x_axis_labels}
\alias{reverse_y_axis_labels}
\alias{reverse_color_labels}
\title{Reverse axis or color labels}
\usage{
reverse_x_axis_labels(plot)

reverse_y_axis_labels(plot)

reverse_color_labels(plot)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Reverse axis or color labels
}
\examples{
# Before adjustments
study \%>\%
  tidyplot(x = treatment, y = score) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

# Reverse x axis labels
study \%>\%
  tidyplot(x = treatment, y = score) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  reverse_x_axis_labels()

# Before adjustments
study \%>\%
  tidyplot(x = score, y = treatment) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

# Reverse y axis labels
study \%>\%
  tidyplot(x = score, y = treatment) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  reverse_y_axis_labels()

# Before adjustment
study \%>\%
  tidyplot(x = group, y = score, color = dose) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

# Reverse color labels
study \%>\%
  tidyplot(x = group, y = score, color = dose) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  reverse_color_labels()

}
