% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_norm.R
\name{norm_dct_lobanov}
\alias{norm_dct_lobanov}
\title{Lobanov DCT Normalization}
\usage{
norm_dct_lobanov(
  .data,
  ...,
  .token_id_col,
  .by = NULL,
  .param_col = NULL,
  .names = "{.formant}_z",
  .silent = FALSE,
  .drop_orig = FALSE
)
}
\arguments{
\item{.data}{A data frame of formant DCT coefficients}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.token_id_col}{\code{\link[rlang:args_data_masking]{<data-masking>}} A column
that identifies token ids.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.param_col}{A column identifying the DCT parameter number.}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Whether or not the informational message should be printed.}

\item{.drop_orig}{Should the originally targeted columns be dropped.}
}
\value{
A data frame of Lobanov normalized DCT Coefficients.
}
\description{
Lobanov DCT Normalization
}
\details{
\deqn{
  \hat{F}_{ij} = \frac{F_{ij} - L_i}{S_i}
}

\deqn{
  L_i = \frac{1}{N}\sum_{j=1}^{N}F_{ij}
}

\deqn{
  S_i = \sqrt{\frac{\sum(F_{ij}-L_i)^2}{N-1}}
}

Where
\itemize{
\item \eqn{\hat{F}} is the normalized formant
\item \eqn{i} is the formant number
\item \eqn{j} is the token number
}
}
\examples{
library(tidynorm)
library(dplyr)
ggplot2_inst <- require(ggplot2)

speaker_dct <- speaker_tracks |>
  reframe_with_dct(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .time_col = t
  )

# Normalize DCT coefficients
speaker_dct_norm <- speaker_dct |>
  norm_dct_lobanov(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .param_col = .param
  )

# Apply average and apply inverse dct
# to plot tracks
track_norm_means <- speaker_dct_norm |>
  summarise(
    .by = c(speaker, vowel, .param),
    across(
      ends_with("_z"),
      mean
    )
  ) |>
  reframe_with_idct(
    ends_with("_z"),
    .by = speaker,
    .token_id_col = vowel,
    .param_col = .param
  )


if (ggplot2_inst) {
  track_norm_means |>
    ggplot(
      aes(F2_z, F1_z, color = speaker)
    ) +
    geom_path(
      aes(
        group = interaction(speaker, vowel)
      )
    ) +
    scale_x_reverse() +
    scale_y_reverse() +
    scale_color_brewer(palette = "Dark2") +
    coord_fixed()
}
}
\references{
Lobanov, B. (1971). Classification of Russian vowels spoken by different listeners.
Journal of the Acoustical Society of America, 49, 606–608.
}
