% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{with_margins}
\alias{with_margins}
\title{Operate over margins}
\usage{
with_margins(FUN, all.name = "(All)")
}
\arguments{
\item{FUN}{the function to wrap.}

\item{all.name}{the string to use to represent that a variable was marginalized over.}
}
\value{
Returns a function which alters the given \code{FUN} to be run for
each possible subset of groupings and \link[dplyr:bind_rows]{row bind}
the results together.
}
\description{
Alter a function to operate over groups and all possible
subsets of groupings, including no grouping.
}
\examples{
library(dplyr)
x <- c( 'a', 'b', 'c')
y <- c( 'd', 'e', 'f')
data <- group_by(mutate(expand.grid( x = x, y = y, .rep = 1:10),  v = rnorm(90)), x, y)
with_margins(summarise)(data, N=n(), sum=sum(v))
}
\seealso{
For understanding marginals:
\itemize{
\item \href{https://en.wikipedia.org/wiki/Marginal_distribution}{Marginal distributions} on Wikipedia.
\item \href{https://stattrek.com/statistics/dictionary.aspx?definition=marginal_frequency}{Marginal frequency} on statistics dictionary.
}
}
