% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message_retrieval.R
\name{get_metadata}
\alias{get_metadata}
\alias{last_metadata}
\title{Retrieve Metadata from Assistant Replies}
\usage{
get_metadata(.llm, .index = NULL)

last_metadata(.llm)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object containing the message history.}

\item{.index}{A positive integer specifying which assistant reply's metadata to extract.
If \code{NULL} (default), metadata for all replies is returned.}
}
\value{
A tibble containing metadata for the specified assistant reply or all replies.
}
\description{
Retrieves metadata from assistant replies within an \code{LLMMessage} object.
It returns the metadata as a tibble.
}
\details{
Metadata columns may include:
\itemize{
\item \code{model}: The model used for generating the reply.
\item \code{timestamp}: The time when the reply was generated.
\item \code{prompt_tokens}: The number of tokens in the input prompt.
\item \code{completion_tokens}: The number of tokens in the assistant's reply.
\item \code{total_tokens}: The total number of tokens (prompt + completion).
\item \code{api_specific}: A list column with API-specific metadata.
}

For convenience, \code{\link[=last_metadata]{last_metadata()}} is provided to retrieve the metadata for the last message.
}
\seealso{
\code{\link[=last_metadata]{last_metadata()}}
}
