% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_openai.R
\name{chatgpt}
\alias{chatgpt}
\title{Alias for the OpenAI Provider Function}
\usage{
chatgpt(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the appropriate OpenAI-specific function,
such as model configuration, input text, or other API-specific options.}

\item{.called_from}{An internal argument that specifies the context (e.g.,
\code{chat}, \code{embed}, \code{send_batch}) in which the function is being
invoked. This is automatically managed and should not be modified by the user.}
}
\value{
The result of the requested action, depending on the specific function invoked
(e.g., an updated \code{LLMMessage} object for \code{chat()}, or a matrix for \code{embed()}).
}
\description{
The \code{chatgpt} function is an alias for the \code{openai()} provider function.
It provides a convenient way to interact with the OpenAI API for tasks such
as sending chat messages, generating embeddings, and handling batch operations
using \code{tidyllm} verbs like \code{chat()}, \code{embed()}, and \code{send_batch()}.
}
