% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qoi.R
\name{construct_pseudo_outcomes}
\alias{construct_pseudo_outcomes}
\title{Construct Pseudo-outcomes}
\usage{
construct_pseudo_outcomes(data, outcome, treatment, type = "dr")
}
\arguments{
\item{data}{dataframe (already prepared with \code{attach_config}, \code{make_splits},
and \code{produce_plugin_estimates})}

\item{outcome}{Unquoted name of outcome variable.}

\item{treatment}{Unquoted name of treatment variable.}

\item{type}{String representing how to construct the pseudo-outcome. Valid
values are "dr" (the default), "ipw" and "plugin". See "Details" for more
discussion of these options.}
}
\description{
\code{construct_pseudo_outcomes} takes a dataset which has been prepared
with plugin estimators of nuisance parameters and transforms these into
a "pseudo-outcome": an unbiased estimator of the conditional average
treatment effect under exogeneity.
}
\details{
Taking averages of these pseudo-outcomes (or fitting a model to them)
will approximate averages (or models) of the underlying treatment effect.
}
\seealso{
\code{\link[=attach_config]{attach_config()}}, \code{\link[=make_splits]{make_splits()}}, \code{\link[=produce_plugin_estimates]{produce_plugin_estimates()}}, \code{\link[=estimate_QoI]{estimate_QoI()}}
}
