% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-api.R
\name{add_effect_diagnostic}
\alias{add_effect_diagnostic}
\title{Add an additional diagnostic to the effect model}
\usage{
add_effect_diagnostic(hte_cfg, diag)
}
\arguments{
\item{hte_cfg}{\code{HTE_cfg} object to update.}

\item{diag}{Character indicating the name of the diagnostic
to include. Possible values are \code{"MSE"}, \code{"RROC"} and, for
\code{SuperLearner} ensembles, \code{"SL_risk"} and \code{"SL_coefs"}.}
}
\value{
Updated \code{HTE_cfg} object
}
\description{
This adds a diagnostic to the effect model.
}
\examples{
library("dplyr")
basic_config() \%>\%
   add_effect_diagnostic("RROC") -> hte_cfg
}
