% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{dt_unnest}
\alias{dt_unnest}
\title{Unnest: Fast Unnesting of Data Tables}
\usage{
dt_unnest(dt_, col, ...)
}
\arguments{
\item{dt_}{the data table to unnest}

\item{col}{the column to unnest}

\item{...}{any of the other variables in the nested table that you want to keep in the unnested table. Bare variable names. If none are provided, all variables are kept.}
}
\description{
Quickly unnest data tables, particularly those nested by \code{dt_nest()}.
}
\examples{

library(data.table)
dt <- data.table(
  x = rnorm(1e5),
  y = runif(1e5),
  grp = sample(1L:3L, 1e5, replace = TRUE)
  )

nested <- dt_nest(dt, grp)
dt_unnest(nested, col = data)

}
