% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncount.R
\name{dt_uncount}
\alias{dt_uncount}
\title{Uncount}
\usage{
dt_uncount(dt_, weights, .remove = TRUE, .id = NULL)
}
\arguments{
\item{dt_}{the data table to uncount}

\item{weights}{the counts for each}

\item{.remove}{should the weights variable be removed?}

\item{.id}{an optional new id variable, providing a unique id for each row}
}
\value{
A data.table with a row for each uncounted column.
}
\description{
Uncount a counted data table
}
\examples{

library(data.table)

dt_count <- data.table(
  x = LETTERS[1:3],
  w = c(2,1,4)
)
uncount <- dt_uncount(dt_count, w, .id = "id")
uncount[]      # note that `[]` forces the printing


}
