% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-param.R
\name{get_steps_label}
\alias{get_steps_label}
\title{Get label for steps}
\usage{
get_steps_label(steps)
}
\arguments{
\item{steps}{Steps object parsed by \code{\link{parse_steps}}}
}
\value{
Vector of step labels
}
\description{
Get label for steps
}
\examples{
# steps represented by a dictionary
system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\%
  read_cwl_json() \%>\%
  parse_steps() \%>\%
  get_steps_label()

# steps represented by a list
system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\%
  read_cwl_yaml() \%>\%
  parse_steps() \%>\%
  get_steps_label()
}
