% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_cwl}
\alias{read_cwl}
\title{Read a CWL file into a list}
\usage{
read_cwl(file, format = c("json", "yaml"))
}
\arguments{
\item{file}{A file path, character string, or connection.}

\item{format}{CWL storage format. \code{"json"} or \code{"yaml"}.}
}
\value{
List representation of the input CWL
}
\description{
Read a CWL file into a list
}
\examples{
system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\%
  read_cwl(format = "json")

system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\%
  read_cwl(format = "yaml")
}
